#include "cluceneIndexer.h"

namespace kiwix {

  TCHAR buffer[MAX_BUFFER_SIZE];

  CluceneIndexer::CluceneIndexer(const string &zimFilePath, const string &cluceneDirectoryPath) :
    Indexer(zimFilePath) {

    this->dir = FSDirectory::getDirectory(cluceneDirectoryPath.c_str(), true);
    this->writer = new IndexWriter(dir, &analyzer, true);
  }
  
  void CluceneIndexer::indexNextPercentPre() {
  }
  
  void CluceneIndexer::indexNextArticle(const string &url,
					const string &title,
					const string &unaccentedTitle,
					const string &keywords,
					const string &content) {
    
    Document doc;
    
    /* Not indexed but stored */
    STRCPY_AtoT(buffer, title.c_str(), MAX_BUFFER_SIZE);
    doc.add(*_CLNEW Field(_T("title"), buffer, Field::STORE_YES | Field::INDEX_UNTOKENIZED));

    STRCPY_AtoT(buffer, url.c_str(), MAX_BUFFER_SIZE);
    doc.add(*_CLNEW Field(_T("url"), buffer, Field::STORE_YES | Field::INDEX_UNTOKENIZED));

    /* indexed but not stored */
    STRCPY_AtoT(buffer, unaccentedTitle.c_str(), MAX_BUFFER_SIZE);
    Field *titleField = new Field(_T("utitle"), buffer, Field::STORE_NO | Field::INDEX_TOKENIZED);
    titleField->setBoost(getTitleBoostFactor(content.size()));
    doc.add(*titleField);

    STRCPY_AtoT(buffer, keywords.c_str(), MAX_BUFFER_SIZE);
    Field *keywordsField = new Field(_T("keywords"), buffer, Field::STORE_NO | Field::INDEX_TOKENIZED);
    keywordsField->setBoost(keywordsBoostFactor);
    doc.add(*keywordsField);

    STRCPY_AtoT(buffer, content.c_str(), MAX_BUFFER_SIZE);
    doc.add(*_CLNEW Field(_T("content"), buffer, Field::STORE_NO | Field::INDEX_TOKENIZED));

    /* Add the document to the index */
    this->writer->addDocument(&doc);
  }

  void CluceneIndexer::indexNextPercentPost() {
  }
  
  void CluceneIndexer::stopIndexing() {
    this->writer->optimize();
    this->writer->close();
    delete this->writer;
    delete this->dir;
  }
}
